/* Adobe.Breathe.js -- Breath behavior for Animal */

define(["lib/Zoot", "lib/tasks"],
function (Z, tasks) {
	"use strict";

	return {
		about: "$$$/private/animal/Behavior/Strober/About=Strober behavior",
		description: "$$$/private/animal/Behavior/Strober/Desc=Oscillate the alpha of a puppet",
		uiName: "$$$/private/animal/Behavior/Strober/UIName=Strober",
		defaultArmedForRecordOn: true,
		hideInBehaviorList: true,

		defineParams: function () { // free function, called once ever; returns parameter definition (hierarchical) array
			return [
				{ id: "Waveform", type: "enum", uiName: "$$$/private/animal/Behavior/Strober/Parameter/Waveform=Wave Type",
					items: [{ id: 0, uiName: "$$$/private/animal/Behavior/Strober/Parameter/Waveform/Sine=Sine" },
							{ id: 1, uiName: "$$$/private/animal/Behavior/Strober/Parameter/Waveform/Square=Square"}], dephault: 0
				},
				{ id: "Rate", type: "slider", uiName: "$$$/private/animal/Behavior/Strober/Parameter/Rate=Strobes per Minute", precision: 1, dephault: 60, "min": 0, "max": 500 },
				{ id: "Spin", type: "slider", uiName: "$$$/private/animal/Behavior/Strober/Parameter/Spin=Spin Amount", precision: 1, dephault: 0, "min": -100, "max": 100 },
				{ id: "PhaseMode", type: "checkbox", uiName: "$$$/private/animal/Behavior/Strober/Parameter/PhaseMode=Continuous Phase", dephault: true }
			];
		},

		onCreateBackStageBehavior: function () {
		},

		onCreateStageBehavior: function (self, args) {
		},

		onAnimate: function (self, args) { // method on behavior that is attached to a puppet, only onstage		
			var osc, rate, t = args.t + args.rehearseTime, spin = args.getParam("Spin"), alpha;
			
			rate = args.getParam("Rate");

			if (args.getParam("PhaseMode")) {
				self.lastT = self.lastT || t;
				self.phase = self.phase || 0;

				self.phase += (t-self.lastT)*(rate/60)*Math.PI*2;
				osc = ((Math.sin(self.phase)+1)*0.5);
			} else {
				self.phase = t*(rate/60)*Math.PI*2;
				osc = ((Math.sin(self.phase)+1)*0.5);
			}

			self.lastT = t;
			
			alpha = osc;
			if (args.getParam("Waveform") === 1) {
				alpha = alpha > 0.5 ? 1 : 0;
			}
			
			args.stageLayer.setOpacity(alpha);
		
			if (spin) {
				var transform = Z.Mat3(),
					handle = args.stageLayer.privateLayer.getHandleTreeRoot();
				
				transform = transform.setIdentity().rotate(self.phase*spin);
				tasks.handle.setFrame(handle, transform, tasks.dofs.type.kAffine);
			}
		}

	}; // end of object being returned
});
